﻿#nullable enable
namespace Hims.Api.Models.Patient
{
    /// <summary>
    /// The patient upload document Request.
    /// </summary>
    public class UploadPaymentDocumentRequest
    {
        /// <summary>
        /// Gets or sets the uploaded by.
        /// </summary>
        public int UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient document id.
        /// </summary>
        public int PaymentDocumentId { get; set; }

        /// <summary>
        /// Gets or sets the document url.
        /// </summary>
        public string DocumentUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string ThumbnailUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the document type.
        /// </summary>
        public string DocumentType { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the document name.
        /// </summary>
        public string DocumentName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the content type.
        /// </summary>
        public string ContentType { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the size.
        /// </summary>
        public float Size { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the month.
        /// </summary>
        public string? Month { get; set; }

        /// <summary>
        /// Gets or sets the year.
        /// </summary>
        public string? Year { get; set; }
    }
}
